<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrderOffer extends Model 
{

    protected $table = 'order_offers';
    public $timestamps = true;
    protected $guarded = array('id');
    protected $fillable = array('status', 'provider_id', 'price', 'notes', 'order_id');

    public function order()
    {
        return $this->belongsTo('App\Models\Order');
    }

    public function provider()
    {
        return $this->belongsTo('App\Models\Provider');
    }

}